<?php
session_start();
ob_start();

include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF_Protection
{
    /************START PAGE HEADER*********/
    function Header()
    {


        $rep_name = 'Daybook';

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);


        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");

        }

        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(178, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(178, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(40, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(125, 10, 'For the Period : ' . format_date($from_date) .' To ' . format_date($to_date), 0, 0, 'R');
        $this->Line(11,37,201,37);
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");

#$comp_id = '01';
$comp_id = $_GET['comp_id'];
$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);


$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$acct_id = clean_data($_GET['acct_id']);
$voucher_type = clean_data($_GET['voucher_type']);
$sale_type = clean_data($_GET['sale_type']);

$and = '';



$and_comp = "";



/*************END FINDE COMPANY NAME*****************/

$and = " and substring(v.lineitem,-1)<>'.' and if(substring(v.voucher_id,3,2) in('SL','PL'), substring(v.voucher_id,-1)=1,1=1) ";

$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";


if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
}else{
    $and .= " and v.comp_id in(select comp_id from users_comp where emp_id='$emp_id')";

}



if ($acct_id != "All") {
    $and .= " and v.acct_id = '$acct_id'";
}


if ($voucher_type != "All") {

    $and .= " and substring(v.voucher_id,3,2) = '$voucher_type'";

}


if ($sale_type == "Credit") {

    $and .= " and substring(v.voucher_id,3,2)  in ('SL') and v.acct_id not in ('2610000462', '2610000463','2610000464')";

}

if ($sale_type == "Cash") {

    $and .= " and substring(v.voucher_id,3,2)  in ('SL') and v.acct_id in ('2610000462', '2610000463','2610000464')";

}


try {
    $msqlquery = "SELECT DISTINCT v.voucher_date
                            FROM
                            v_vouchers v
                            WHERE 1=1
                            $and
                            ORDER BY v.voucher_date desc";
#echo $msqlquery;

    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = 0;
$net_amt_tot = '';
$disc_amt_tot = '';
$rec_amt_tot = '';
$rtn_amt_tot = '';
$bal_amt_tot = '';

while ($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {
    $g_voucher_Date = $mrow['voucher_date'];

    try {
        $dd_query = "SELECT v.voucher_type, v.comp_id, v.voucher_id,v.voucher_date,v.acct_id, debit debit_amount, credit credit_amount, v.lineitem, if(substring(v.voucher_id,3,2)='PL' and v.acct_id='2210000001', '',v.particulars) particulars, if(substring(v.voucher_id,3,2)='PL', v.particulars,n.acct_name) acct_name,
                            v.year_id
                FROM v_vouchers v
                LEFT JOIN nom n ON  v.acct_id = n.acct_id
                LEFT JOIN nom n1 ON v.acct_id_cs_1 = n1.acct_id
                LEFT JOIN nom n2 ON v.acct_id_cs_2 = n2.acct_id
                LEFT JOIN company c ON v.comp_id = c.comp_id        
                WHERE 1 = 1 AND  (v.voucher_date = '$g_voucher_Date' )
                      $and 
                order by v.voucher_date, substring(v.voucher_id,3,2), v.comp_id, v.voucher_id, v.lineitem";

        $dd_result = $dbcon->prepare($dd_query);
        $dd_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }


    $sr += 1;

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(1);
    $pdf->Cell(25, 8, format_date($g_voucher_Date), 0);


    $pdf->Ln(8);


    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(15, 8, 'Ser', 1, 'C');
    $pdf->Cell(65, 8, 'Account Name', 1);
    $pdf->Cell(25, 8, 'Voucher Type', 1, 0, 'C');
    $pdf->Cell(25, 8, 'Voucher ID', 1, 0, 'C');

    $pdf->Cell(30, 8, 'Debit', 1, 0, 'R');
    $pdf->Cell(30, 8, 'Credit', 1, 0, 'R');

    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);


    $serno = 0;
    $debit_amount_tot = 0;
    $credit_amount_tot = 0;
    $bal = 0;

    while ($report_row = $dd_result->fetch(PDO::FETCH_ASSOC)) {
        $serno = $serno + 1;
        $debit_amount_tot += $report_row['debit_amount'];
        $credit_amount_tot += $report_row['credit_amount'];
        $bal = $bal + $report_row['debit_amount'] - $report_row['credit_amount'];


        $pdf->Cell(1);
        $pdf->Cell(15, 8, $serno, 1, 'C');
        $pdf->Cell(65, 8, $report_row['acct_name'], 1);

        $pdf->Cell(25, 8, $report_row['voucher_type'], 1, 0, 'C');
        $pdf->Cell(25, 8, $report_row['voucher_id'], 1, 0, 'C');

        $pdf->Cell(30, 8, format_number_pdf($report_row['debit_amount'], 0), 1, 0, 'R');
        $pdf->Cell(30, 8, format_number_pdf($report_row['credit_amount'], 0), 1, 0, 'R');


        $pdf->Ln(8);


    }

}

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(121);
$pdf->Cell(10, 8, 'Total : ', 0, 0,'R');
$pdf->Cell(30, 8, format_number_pdf($debit_amount_tot,0), 1, 0,'R');
$pdf->Cell(30, 8, format_number_pdf($credit_amount_tot,0), 1, 0,'R');

$pdf->Output();


$db_name = $_SESSION['db'];

$filename="dist/".$db_name."/daybook/".$from_date .' - '. $to_date. ".pdf";
$pdf->Output($filename,'F');


require 'PHPMailer/PHPMailerAutoload.php';
$name = 'ClickSfot Pvt Ltd';
$subject = 'Daybook';
$from_email = 'support@clicksoft.com.pk';
$client_mail = 'support@clicksoft.com.pk';
//$client_mail = 'khantraders.click@gmail.com';
//$cc_email = 'backup@clicksoft.com.pk';



$mail = new PHPMailer;
$mail->isSMTP();                            // Set mailer to use SMTP
$mail->Host = 'webs06rdns1.websouls.net';             // Specify main and backup SMTP servers
$mail->SMTPAuth = true;                     // Enable SMTP authentication
$mail->Username = 'support@clicksoft.com.pk';          // SMTP username
$mail->Password = 'clicksoft.765.'; //SMTP password
//$mail->Password = 'ClickSoft_321'; //SMTP password
$mail->SMTPSecure = 'ssl';                  // Enable TLS encryption, `ssl` also accepted
$mail->Port = 465;                          // TCP port to connect to
$mail->SMTPOptions = array(
    'ssl' => array(
        'verify_peer' => false,
        'verify_peer_name' => false,
        'allow_self_signed' => true
    )
);

$mail->setFrom($from_email, $name);
//$mail->addReplyTo($client_mail, $name);
$mail->addAddress($client_mail);   // Add a recipient
$mail->addCC($cc_email);
$mail->addAttachment("dist/".$db_name."/daybook/".$from_date .' - '. $to_date. ".pdf");



$mail->isHTML(true);  // Set email format to HTML

$body = 'Daybook';
$mail->Subject = $subject;
$mail->Body = $body;



if (!$mail->send()) {
    echo 'Message could not be sent.';
    echo 'Mailer Error: ' . $mail->ErrorInfo;
} else {
    echo 'Message has been sent';
}



ob_end_flush();
